###################################################
### code chunk number : set your work directory
###################################################
## 
## Firstly, set your work directory to contain "main_loss_functions_others.R".
## Secondly, make sure there is a folder named "figure"
## in the same directory of "main_loss_functions_others.R".
##


###################################################
### code chunk number : Compare loss functions L(theta, a), 9 points, theta = 2
###################################################
## 
## Compare two loss functions:
## L_2(theta, a), L_s(theta, a)
## 
rm(list=ls(all=TRUE))

theta = 2
a = c(seq(1e-10, 2, by = 0.001), seq(2, 60, by = 10))
y1 = (a - theta)^2 # L_2(theta, a)
y2 = a / theta - log(a / theta) - 1 # L_s(theta, a)


# xp = c(1/5, 1/4, 1/3, 1/2, 1, 2, 3, 4, 5)
# ap = theta * xp
# y1p = (ap - theta)^2 # L_2(theta, a)
# y2p = ap / theta - log(ap / theta) - 1 # L_s(theta, a)


dev.new()
col = c("red", "blue")
lty = 1:2
# pch = c(4, 3, 2, 1, 0, 1, 2, 3, 4)
ylim = c(0, 30) ## range(y1, y2)
plot(a, y1, type = "n", ylim = ylim, xlab = "a", ylab = expression( L(theta[n+1], a) ))
lines(a, y1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y2, lty = lty[2], col = col[2], lwd = 4)
# points(ap, y1p, pch = pch, col = col[1], lwd = 2)
# points(ap, y2p, pch = pch, col = col[2], lwd = 2)
leg.txt = c(expression( L[2](theta[n+1], a) ), expression( L[s](theta[n+1], a) ))
legend("bottomright", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = "figure/L_2_L_s", type = c("pdf"))
savePlot(filename = "figure/L_2_L_s", type = c("jpg"))


####################################################
### code chunk number : Simulations: 1 theta, not good
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu = 0        ## hyperparameter
alpha = 3     ## hyperparameter
beta = 1      ## hyperparameter
n = 1e4

set.seed(1) 
theta = 1 / rgamma(n = 1, shape = alpha, rate = beta); theta
x = rnorm(n, mean = mu, sd = sqrt(theta)) ## the sample

## Histogram
hist(x, probability = TRUE,
    main = paste("Histogram of" , "x"), 
    xlab = "x")
lines(density(x), col = "blue")

## Moment estimators
mu_1_alpha_1_beta_1 = Moment_estimators(x); mu_1_alpha_1_beta_1

## MLE
## The MLE is very sensitive to the initial guess. 
## The moment estimator is usually a good initial guess.
res_Newtons = Newtons(fun = moment_fun, p = mu_1_alpha_1_beta_1, x = x); res_Newtons
mu_2_alpha_2_beta_2 = res_Newtons$root; mu_2_alpha_2_beta_2


####################################################
### code chunk number : Simulations: n theta, good
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu = 0        ## hyperparameter
alpha = 3     ## hyperparameter
beta = 1      ## hyperparameter
n = 1e4

set.seed(1) 
theta = 1 / rgamma(n = n, shape = alpha, rate = beta)
x = rnorm(n = n, mean = mu, sd = sqrt(theta))

## Histogram
hist(x, probability = TRUE,
    main = paste("Histogram of" , "x"), 
    xlab = "x")
lines(density(x), col = "blue")

## Moment estimators
mu_1_alpha_1_beta_1 = Moment_estimators(x); mu_1_alpha_1_beta_1
mu_1 = mu_1_alpha_1_beta_1[1]; mu_1
alpha_1 = mu_1_alpha_1_beta_1[2]; alpha_1
beta_1 = mu_1_alpha_1_beta_1[3]; beta_1

## MLE
## The MLE is very sensitive to the initial guess. 
## The moment estimator is usually a good initial guess.
res_Newtons = Newtons(fun = moment_fun, p = mu_1_alpha_1_beta_1, x = x); res_Newtons
mu_2_alpha_2_beta_2 = res_Newtons$root; mu_2_alpha_2_beta_2


